<?php
require_once("admin/inc/protecao-final.php");

@mysqli_query($conexao,"ALTER TABLE `estatisticas` ADD `cidade` VARCHAR( 255 ) NOT NULL, ADD `estado` VARCHAR( 255 ) NOT NULL;");
@mysqli_query($conexao,"ALTER TABLE `espectadores_conectados` ADD `atualizacao` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP;");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND login = '".$dados_stm["login"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

if(query_string('1') != '' && !is_numeric(query_string('1'))) {
$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".code_decode(query_string('1'),"D")."'"));
} elseif(is_numeric(query_string('1'))) {
$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".query_string('1')."'"));
} else {
$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$_SESSION["login_logado"]."'"));
}

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND login = '".$dados_stm["login"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

if($dados_stm["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_stm["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}

$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);
    
if($status_streaming["status"] == "loaded") {

$array_estatisticas = estatistica_espectadores_conectados($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"],$dados_stm["aplicacao"]);

$estatisticas = $array_estatisticas;

// Insere os espectadores conectados na tabela temporaria
if(count($estatisticas) > 0) {

$sql_check = mysqli_query($conexao,"SELECT codigo_stm,ip FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."'");
while ($dados_check = mysqli_fetch_array($sql_check)) {

  if(!preg_grep('/'.$dados_check["ip"].'/i',$estatisticas)) {
    mysqli_query($conexao,"Delete From espectadores_conectados where ip = '".$dados_check["ip"]."' AND codigo_stm = '".$dados_stm["codigo"]."'");
  }

}

$array_uniq_ips = array();

foreach($estatisticas as $estatistica) {

list($ip, $tempo_conectado, $player) = explode("|",$estatistica);

if(!in_array($ip, $array_uniq_ips)) {

if(filter_var($ip, FILTER_VALIDATE_IP)) {

// Verifica se ja tem no banco de dados de geoip e usa banco de dados ao invez da API
$verifica_ip_db_atual = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM espectadores_conectados where ip = '".$ip."' AND codigo_stm = '".$dados_stm["codigo"]."'"));

if($verifica_ip_db_atual == 0) {

$dados_api_geoip = api_geoip($ip);

$ip_pais_codigo = $dados_api_geoip["pais_sigla"];
$ip_pais_nome = $dados_api_geoip["pais_nome"];
$ip_estado = $dados_api_geoip["estado"];
$ip_cidade = $dados_api_geoip["cidade"];
$latitude = $dados_api_geoip["latitude"];
$longitude = $dados_api_geoip["longitude"];

mysqli_query($conexao,"INSERT INTO espectadores_conectados (codigo_stm,ip,tempo_conectado,pais_sigla,pais_nome,cidade,estado,player,latitude,longitude) VALUES ('".$dados_stm["codigo"]."','".$ip."','".$tempo_conectado."','".$ip_pais_codigo."','".$ip_pais_nome."','".$ip_estado."','".$ip_cidade."','".$player."','".$latitude."','".$longitude."')");

} else {

mysqli_query($conexao,"Update espectadores_conectados set tempo_conectado = '".$tempo_conectado."', atualizacao = NOW() where ip = '".$ip."' AND codigo_stm = '".$dados_stm["codigo"]."'");

} // fim if verifica ip "cache" banco de dados

$array_uniq_ips[] = $ip;

}

}

$get_Avg = mysqli_fetch_array(mysqli_query($conexao,"SELECT AVG(tempo_conectado) AS tempo FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$total_espectadores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."'"));

}
}

}


$COUNTRY_LAT_LANG = array( "AD" => array(42.50, 1.50), "AE" => array(24.00, 54.00), "AF" => array(33.00, 65.00), "AG" => array(17.05, -61.80), "AI" => array(18.22, -63.05), "AL" => array(41.00, 20.00), "AM" => array(40.00, 45.00), "AN" => array(12.17, -69.00), "AO" => array(-12.50, 18.50), "AQ" => array(-77.85, 166.67), "AR" => array(-34.00, -64.00), "AS" => array(-14.32, -170.50), "AT" => array(47.33, 13.33), "AU" => array(-25.00, 135.00), "AW" => array(12.50, -69.97), "AX" => array(60.12, 19.90), "AZ" => array(40.50, 47.50), "BA" => array(44.25, 17.83), "BB" => array(13.17, -59.53), "BD" => array(24.00, 90.00), "BE" => array(50.83, 4.00), "BF" => array(13.00, -2.00), "BG" => array(43.00, 25.00), "BH" => array(26.00, 50.50), "BI" => array(-3.50, 30.00), "BJ" => array(9.50, 2.25), "BM" => array(32.33, -64.75), "BN" => array(4.50, 114.67), "BO" => array(-17.00, -65.00), "BR" => array(-10.00, -55.00), "BS" => array(24.00, -76.00), "BT" => array(27.50, 90.50), "BV" => array(-54.43, 3.40), "BW" => array(-22.00, 24.00), "BY" => array(53.00, 28.00), "BZ" => array(17.25, -88.75), "CA" => array(60.00, -96.00), "CC" => array(-12.17, 96.83), "CD" => array(-3.52, 23.42), "CF" => array(7.00, 21.00), "CG" => array(-1.00, 15.00), "CH" => array(47.00, 8.00), "CI" => array(8.00, -5.00), "CK" => array(-20.00, -158.00), "CL" => array(-30.00, -71.00), "CM" => array(6.00, 12.00), "CN" => array(35.00, 105.00), "CO" => array(4.00, -72.00), "CR" => array(10.00, -84.00), "CS" => array(44.8, 20.5), "CU" => array(21.50, -80.00), "CV" => array(16.00, -24.00), "CX" => array(-10.50, 105.67), "CY" => array(35.00, 33.00), "CZ" => array(49.75, 15.00), "DE" => array(51.50, 10.50), "DJ" => array(11.50, 42.50), "DK" => array(56.00, 10.00), "DM" => array(15.50, -61.33), "DO" => array(19.00, -70.67), "DZ" => array(28.00, 3.00), "EC" => array(-2.00, -77.50), "EE" => array(59.00, 26.00), "EG" => array(27.00, 30.00), "EH" => array(23.00, -14.00), "ER" => array(15.00, 39.00), "ES" => array(40.00, -4.00), "ET" => array(8.00, 39.00), "FI" => array(64.00, 26.00), "FJ" => array(-18.00, 178.00), "FK" => array(-51.75, -59.00), "FM" => array(5.00, 152.00), "FO" => array(62.00, -7.00), "FR" => array(46.00, 2.00), "FX" => array(48.87, 2.33), "GA" => array(-1.00, 11.75), "GB" => array(54.00, -4.50), "GD" => array(12.12, -61.67), "GE" => array(42.00, 43.50), "GF" => array(4.00, -53.00), "GG" => array(49.45, -2.55), "GH" => array(8.00, -2.00), "GI" => array(36.13, -5.35), "GL" => array(72.00, -40.00), "GM" => array(13.50, -15.50), "GN" => array(11.00, -10.00), "GP" => array(16.25, -61.58), "GQ" => array(2.00, 10.00), "GR" => array(39.00, 22.00), "GS" => array(-54.50, -37.00), "GT" => array(15.50, -90.25), "GU" => array(13.47, 144.83), "GW" => array(12.00, -15.00), "GY" => array(5.00, -59.00), "HK" => array(22.25, 114.17), "HM" => array(-53.10, 73.52), "HN" => array(15.00, -86.50), "HR" => array(45.17, 15.50), "HT" => array(19.00, -72.42), "HU" => array(47.00, 20.00), "ID" => array(-5.00, 120.00), "IE" => array(53.00, -8.00), "IL" => array(31.50, 34.75), "IM" => array(54.23, -4.55), "IN" => array(20.00, 77.00), "IO" => array(-6.00, 71.50), "IQ" => array(33.00, 44.00), "IR" => array(32.00, 53.00), "IS" => array(65.00, -18.00), "IT" => array(42.83, 12.83), "JE" => array(49.19, -2.11), "JM" => array(18.25, -77.50), "JO" => array(31.00, 36.00), "JP" => array(36.00, 138.00), "KE" => array(1.00, 38.00), "KG" => array(41.00, 75.00), "KH" => array(13.00, 105.00), "KI" => array(-5.00, -170.00), "KM" => array(-12.17, 44.25), "KN" => array(17.33, -62.75), "KP" => array(40.00, 127.00), "KR" => array(37.00, 127.50), "KW" => array(29.50, 47.75), "KY" => array(19.50, -80.67), "KZ" => array(48.00, 68.00), "LA" => array(18.00, 105.00), "LB" => array(33.83, 35.83), "LC" => array(13.88, -60.97), "LI" => array(47.17, 9.53), "LK" => array(7.00, 81.00), "LR" => array(6.50, -9.50), "LS" => array(-29.50, 28.25), "LT" => array(56.00, 24.00), "LU" => array(49.75, 6.17), "LV" => array(57.00, 25.00), "LY" => array(25.00, 17.00), "MA" => array(32.00, -5.00), "MC" => array(43.73, 7.42), "MD" => array(47.00, 29.00), "ME" => array(42.80, 19.20), "MG" => array(-20.00, 47.00), "MH" => array(11.00, 168.00), "MK" => array(41.83, 22.00), "ML" => array(17.00, -4.00), "MM" => array(22.00, 98.00), "MN" => array(46.00, 105.00), "MO" => array(22.00, 113.00), "MP" => array(15.12, 145.67), "MQ" => array(14.67, -61.00), "MR" => array(20.00, -12.00), "MS" => array(16.75, -62.20), "MT" => array(35.92, 14.42), "MU" => array(-20.30, 57.58), "MV" => array(3.20, 73.00), "MW" => array(-13.50, 34.00), "MX" => array(23.00, -102.00), "MY" => array(4.22, 101.97), "MZ" => array(-18.25, 35.00), "NA" => array(-22.00, 17.00), "NC" => array(-21.50, 165.50), "NE" => array(16.00, 8.00), "NF" => array(-29.08, 167.92), "NG" => array(10.00, 8.00), "NI" => array(13.00, -85.00), "NL" => array(52.50, 5.75), "NO" => array(62.00, 10.00), "NP" => array(28.00, 84.00), "NR" => array(-0.53, 166.92), "NU" => array(-19.03, -169.87), "NZ" => array(-42.00, 174.00), "OM" => array(21.00, 57.00), "PA" => array(9.00, -80.00), "PE" => array(-10.00, -76.00), "PF" => array(-15.00, -140.00), "PG" => array(-6.00, 147.00), "PH" => array(13.00, 122.00), "PK" => array(30.00, 70.00), "PL" => array(52.00, 20.00), "PM" => array(46.83, -56.33), "PN" => array(-25.07, -130.08), "PR" => array(18.23, -66.55), "PS" => array(32.0000, 35.2500), "PT" => array(39.50, -8.00), "PW" => array(6.00, 134.00), "PY" => array(-23.00, -58.00), "QA" => array(25.50, 51.25), "RE" => array(-21.10, 55.60), "RO" => array(46.00, 25.00), "RS" => array(43.80, 21.00), "RU" => array(60.00, 47.00), "RW" => array(-2.00, 30.00), "SA" => array(25.00, 45.00), "SB" => array(-8.00, 159.00), "SC" => array(-4.58, 55.67), "SD" => array(15.00, 30.00), "SE" => array(62.00, 15.00), "SG" => array(1.37, 103.80), "SH" => array(-15.95, -5.70), "SI" => array(46.25, 15.17), "SJ" => array(78.00, 20.00), "SK" => array(48.67, 19.50), "SL" => array(8.50, -11.50), "SM" => array(43.93, 12.42), "SN" => array(14.00, -14.00), "SO" => array(6.00, 48.00), "SR" => array(4.00, -56.00), "ST" => array(1.00, 7.00), "SU" => array(60.00, 47.00), "SV" => array(13.83, -88.92), "SY" => array(35.00, 38.00), "SZ" => array(-26.50, 31.50), "TC" => array(21.73, -71.58), "TD" => array(15.00, 19.00), "TF" => array(-43.00, 67.00), "TG" => array(8.00, 1.17), "TH" => array(15.00, 100.00), "TJ" => array(39.00, 71.00), "TK" => array(-9.00, -171.75), "TL" => array(-8.87, 125.72), "TM" => array(40.00, 60.00), "TN" => array(34.00, 9.00), "TO" => array(-20.00, -175.00), "TP" => array(-9.00, 125.00), "TR" => array(39.00, 35.00), "TT" => array(11.00, -61.00), "TV" => array(-8.00, 178.00), "TW" => array(23.50, 121.00), "TZ" => array(-6.00, 35.00), "UA" => array(49.00, 32.00), "UG" => array(2.00, 33.00), "UM" => array(10.00, -175.00), "US" => array(38.00, -98.00), "UY" => array(-33.00, -56.00), "UZ" => array(41.00, 64.00), "VA" => array(41.90, 12.45), "VC" => array(13.08, -61.20), "VE" => array(8.00, -66.00), "VG" => array(18.50, -64.50), "VI" => array(18.50, -64.43), "VN" => array(16.00, 106.00), "VU" => array(-16.00, 167.00), "WF" => array(-14.00, -177.00), "WS" => array(-13.58, -172.33), "YE" => array(15.50, 47.50), "YT" => array(-12.83, 45.17), "YU" => array(44.00, 21.00), "ZA" => array(-30.00, 26.00), "ZM" => array(-15.00, 30.00), "ZR" => array(-1.00, 22.00), "ZW" => array(-19.00, 29.00) );

/////////////////////////////////////////////////
/////////////////// Idioma //////////////////////
/////////////////////////////////////////////////
if($dados_stm["idioma_painel"] == "pt-br") {
$lang[ 'lang_info_mapa_filtrar_pais' ] = 'Filtrar por Pais' ;
$lang[ 'lang_info_mapa_filtrar_estado' ] = 'Filtrar por Estado' ;
$lang[ 'lang_info_mapa_geral' ] = 'Mapa Geral' ;
$lang[ 'lang_info_espectadores_conectados_localidade' ] = 'Localidade' ;
} else if($dados_stm["idioma_painel"] == "en") {
$lang[ 'lang_info_mapa_filtrar_pais' ] = 'Filter by Country' ;
$lang[ 'lang_info_mapa_filtrar_estado' ] = 'Filter by State' ;
$lang[ 'lang_info_mapa_geral' ] = 'General Map' ;
$lang[ 'lang_info_espectadores_conectados_localidade' ] = 'Location' ;
} else {
$lang[ 'lang_info_mapa_filtrar_pais' ] = 'Filtro por Pais' ;
$lang[ 'lang_info_mapa_filtrar_estado' ] = 'Filtro por Departamento' ;
$lang[ 'lang_info_mapa_geral' ] = 'Mapa General' ;
$lang[ 'lang_info_espectadores_conectados_localidade' ] = 'Ubicacion' ;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["login"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">  
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css" integrity="sha256-kLaT2GOSpHechhsozzB+flnD+zUyjE2LlfWPgU04xyI=" crossorigin=""/> 
  <?php if($dados_stm["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico" />
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
        <script src="https://code.highcharts.com/highcharts.js"></script>
        <script src="https://code.highcharts.com/highcharts-3d.js"></script>
        <script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js" integrity="sha256-WBkoXOwTeyKclOHuWtc+i2uENFpDZ9YPdf5Hf+D7ewM=" crossorigin=""></script>
</head>
<body>
  <div class="container-scroller">
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><i class="fa fa-video-camera text-muted"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item" style=" padding-top: 15px; font-size: 15px; ">
            <input type="checkbox" id="desativar_agendamentos" name="desativar_agendamentos" value="sim" <?php if($dados_stm["desativar_agendamentos"] == "desativado") { echo 'checked="checked"';} ?> /> Desativar Agendamentos
          </li>
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $login_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-warning" href="javascript:reiniciar_streaming('<?php echo $login_code; ?>');"> <?php echo $lang['lang_botao_titulo_reiniciar']; ?> Streaming</a>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <?php if($_SESSION["painel_gerenciador"] == "admin") { ?>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-streamings"><i class="mdi mdi-lock f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Painel Administra&ccedil;&atilde;o"></i></a>
          </li>
          <?php } ?>
          <?php if($_SESSION["painel_gerenciador"] == "revenda") { ?>
          <li class="nav-item">
            <a class="nav-link" href="/admin/revenda"><i class="mdi mdi-lock f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Painel Revenda"></i></a>
          </li>
          <?php } ?>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $login_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>
    <div class="container-fluid page-body-wrapper">
      <?php require_once("menu.php"); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_espectadores_conectados_trans_atual_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                              <td width="25%" height="70" align="center"><i class='fa fa-users f-48 text-blue'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-clock-o f-48 text-blue'></i></td>
                                            </tr>
                                            <tr>
                                              <td height="30" align="center"><?php echo @count($estatisticas); ?><br /><?php echo $lang['lang_info_espectadores_conectados_trans_total_espectadores']; ?></td>
                                              <td align="center"><?php echo seconds2time($get_Avg["tempo"]+1800); ?><br /><?php echo $lang['lang_info_espectadores_conectados_trans_total_tempo_medio']; ?></td>
                                            </tr>
                                          </table>
                                    </div>
                                </div>
                            </div>

                            <?php if(@count($estatisticas) > 0) { ?>

                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_espectadores_conectados_paises_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-block">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                <tr>
                                                <?php
                                                if(count($estatisticas) > 0) {
                                                $count = 0;

                                                $sql_paises = mysqli_query($conexao,"SELECT *, count(pais_sigla) as total FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' GROUP by pais_sigla ORDER by total DESC LIMIT 5");
                                                while ($dados_pais = mysqli_fetch_array($sql_paises)) {

                                                if(!($count % 2)){ echo "<tr></tr>"; }

                                                echo '<td width="50%" height="35" align="left" scope="col" style="padding-left:10px;"><img src="/img/icones/paises/'.strtolower($dados_pais["pais_sigla"]).'.png" border="0" width="16" height="11" align="absmiddle" />&nbsp;&nbsp;'.$dados_pais["pais_nome"].'&nbsp;&nbsp;('.$dados_pais["total"].')</td>';

                                                $count++;
                                                }

                                                }
                                                ?>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_espectadores_conectados_players_tab_titulo']; ?></header>
                                    </div>
                                    <div class="card-block">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                <tr>
                                                <?php
                                                if(count($estatisticas) > 0) {
                                                $count = 0;

                                                $sql_player = mysqli_query($conexao,"SELECT *, count(player) as total FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' GROUP by player ORDER by total DESC LIMIT 5");
                                                while ($dados_player = mysqli_fetch_array($sql_player)) {

                                                $player_icone = (file_exists("img/icones/players/".str_replace(" ","",$dados_player["player"]).".png")) ? str_replace(" ","",$dados_player["player"]) : "Outro";

                                                if(!($count % 2)){ echo "<tr></tr>"; }

                                                echo '<td width="50%" height="35" align="left" scope="col" style="padding-left:10px;"><img src="/img/icones/players/'.$player_icone.'.png" border="0" width="16" height="16" align="absmiddle" />&nbsp;&nbsp;'.$dados_player["player"].'&nbsp;&nbsp;('.$dados_player["total"].')</td>';

                                                $count++;
                                                }

                                                }
                                                ?>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_espectadores_conectados_tab_titulo']; ?></header>
                                    </div>
                                        <div class="table-responsive">
                                            <table id="data_table" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_espectadores_conectados_ip']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_espectadores_conectados_pais']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_espectadores_conectados_player']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_espectadores_conectados_tempo_conectado']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php

$sql_espectadores = mysqli_query($conexao,"SELECT * FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by ip ASC");
while ($dados_espectador = mysqli_fetch_array($sql_espectadores)) {

$localidade .= ($dados_espectador["estado"]) ? " - ".$dados_espectador["estado"]."" : "";
$localidade .= ($dados_espectador["cidade"]) ? " - ".$dados_espectador["cidade"]."" : "";

$player_icone = (file_exists("img/icones/players/".str_replace(" ","",$dados_espectador["player"]).".png")) ? str_replace(" ","",$dados_espectador["player"]) : "Outro";

echo "
  <tr>
    <td height='23' class='texto_padrao'>&nbsp;".$dados_espectador["ip"]."</td>
    <td height='23' class='texto_padrao'>&nbsp;<img src='/img/icones/paises/".strtolower($dados_espectador["pais_sigla"]).".png' border='0' style='width:16px!important;height:11px!important;border-radius:0!important;' align='absmiddle' />&nbsp;".$dados_espectador["pais_nome"]."".$localidade."</td>
    <td height='23' class='texto_padrao'>&nbsp;<img src='/img/icones/players/".$player_icone.".png' border='0'  style='width:16px!important;height:16px!important;border-radius:0!important;' align='absmiddle' />&nbsp;".$dados_espectador["player"]."</td>
    <td height='23' class='texto_padrao'>&nbsp;".seconds2time($dados_espectador["tempo_conectado"])."</td>
  </tr>
";
unset($localidade);

}
?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                            </div>

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="input-group">
                                          <select class="form-control" style="width:50%;height:40px" onchange="filtrar_mapa(this.value);">
                                            <option hidden selected ><?php echo $lang['lang_info_mapa_filtrar_pais']; ?></option>
                                            <option value="0,0,2"><?php echo $lang['lang_info_mapa_geral']; ?></option>
                                            <?php
                                              if(count($estatisticas) > 0) {

                                                $sql_mapa_pais = mysqli_query($conexao,"SELECT *, count(pais_sigla) as total FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' GROUP by pais_sigla ORDER by total DESC");
                                                while ($dados_mapa_pais = mysqli_fetch_array($sql_mapa_pais)) {

                                                  if($COUNTRY_LAT_LANG["".$dados_mapa_pais["pais_sigla"].""][0] && $COUNTRY_LAT_LANG["".$dados_mapa_pais["pais_sigla"].""][1]) {
                                                    echo '<option value="'.$COUNTRY_LAT_LANG["".$dados_mapa_pais["pais_sigla"].""][0].','.$COUNTRY_LAT_LANG["".$dados_mapa_pais["pais_sigla"].""][1].',4">'.$dados_mapa_pais["pais_nome"].' ('.$dados_mapa_pais["total"].')</option>';
                                                  }
                                                }

                                              }
                                              ?>
                                          </select>
                                          <select class="form-control" style="width:50%;height:40px" onchange="filtrar_mapa(this.value);">
                                            <option hidden selected value="0,0,2"><?php echo $lang['lang_info_mapa_filtrar_estado']; ?></option>
                                            <option value="0,0,2"><?php echo $lang['lang_info_mapa_geral']; ?></option>
                                            <?php
                                              if(count($estatisticas) > 0) {

                                                $sql_mapa_estado = mysqli_query($conexao,"SELECT *, count(estado) as total FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' GROUP by estado ORDER by total DESC");
                                                while ($dados_mapa_estado = mysqli_fetch_array($sql_mapa_estado)) {

                                                  if($dados_mapa_estado["latitude"] && $dados_mapa_estado["longitude"] && $dados_mapa_estado["estado"]) {
                                                    echo '<option value="'.$dados_mapa_estado["latitude"].','.$dados_mapa_estado["longitude"].',6">'.$dados_mapa_estado["estado"].' ('.$dados_mapa_estado["total"].')</option>';
                                                  }
                                                }

                                              }
                                              ?>
                                          </select>
                                        </div>
                                          <div id="mapa_espectadores" style="width:100%; height: 400px; margin: 0 auto"></div>
                                        <script type="text/javascript">
                                            var locations = [
                                              <?php
                                              if(count($estatisticas) > 0) {

                                              $sql_ouvintes = mysqli_query($conexao,"SELECT * FROM espectadores_conectados WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by ip ASC");
                                              while ($dados_ouvinte = mysqli_fetch_array($sql_ouvintes)) {

                                              $latitude = $dados_ouvinte["latitude"];
                                              $longitude = $dados_ouvinte["longitude"];

                                              $player_icone = (file_exists("img/icones/players/".str_replace(" ","",$dados_ouvinte["player"]).".png")) ? str_replace(" ","",$dados_ouvinte["player"]) : "Outro";

                                              echo "['<strong>".$lang['lang_info_espectadores_conectados_ouvinte'].":</strong> ".$dados_ouvinte["ip"]."<br><strong>".$lang['lang_info_espectadores_conectados_localidade'].":</strong> ".addslashes($dados_ouvinte["estado"])." - ".addslashes($dados_ouvinte["cidade"])."<br><strong>Player:</strong> <img src=\"/img/icones/players/".$player_icone.".png\" border=\"0\" width=\"16\" height=\"16\" align=\"absmiddle\" />&nbsp;".$dados_ouvinte["player"]."', ".$latitude.", ".$longitude."],";

                                              }

                                              }
                                              ?>];

                                              const map = L.map('mapa_espectadores').setView([0, 0], 2);

                                              const tiles = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
                                                maxZoom: 19,
                                                attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
                                              }).addTo(map);

                                              for (var i = 0; i < locations.length; i++) {
                                                marker = new L.marker([locations[i][1], locations[i][2]])
                                                  .bindPopup(locations[i][0])
                                                  .addTo(map);
                                              }
                                              function filtrar_mapa(coord) {

                                              const coords = coord.split(',');
                                              map.flyTo([coords[0], coords[1]], coords[2]);

                                              }
                                            </script>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        <script type="text/javascript">
                                            // Graficos
                                            $(function () {
                                                var chart;
                                                $(document).ready(function() {
                                                    chart = new Highcharts.Chart({
                                                        chart: {
                                                            renderTo: 'grafico_horas',
                                                            type: 'area'
                                                        },
                                                        title: {
                                                            text: '<?php echo $lang['lang_info_espectadores_conectados_estatisticas_titulo']; ?>'
                                                        },
                                                        subtitle: {
                                                            text: '<?php echo formatar_data($dados_stm["formato_data"], date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-1, date("Y"))), $dados_stm["timezone"]). " - " . formatar_data($dados_stm["formato_data"], date("Y-m-d"), $dados_stm["timezone"]);?>'
                                                        },
                                                        xAxis: {
                                                            categories: ['00:00-00:59','01:00-01:59','02:00-02:59','03:00-03:59','04:00-04:59','05:00-05:59','06:00-06:59','07:00-07:59','08:00-08:59','09:00-09:59','10:00-10:59','11:00-11:59','12:00-12:59','13:00-13:59','14:00-14:59','15:00-15:59','16:00-16:59','17:00-17:59','18:00-18:59','19:00-19:59','20:00-20:59','21:00-21:59','22:00-22:59','23:00-23:59'],
                                                            tickmarkPlacement: 'on',
                                                            title: {
                                                                enabled: true,
                                                                text: '<?php echo $lang['lang_info_espectadores_conectados_estatisticas_info_hora']; ?>'
                                                            }
                                                        },
                                                        yAxis: {
                                                            title: {
                                                                text: '<?php echo $lang['lang_info_espectadores_conectados_estatisticas_total_espectadores']; ?>'
                                                            },
                                                            labels: {
                                                                formatter: function() {
                                                                    return this.value;
                                                                }
                                                            }
                                                        },
                                                        tooltip: {
                                                            formatter: function() {
                                                                return ''+this.x+': '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_espectadores_conectados_estatisticas_balao_espectadores']; ?>';
                                                            }
                                                        },
                                                        plotOptions: {
                                                            area: {
                                                                stacking: 'normal',
                                                                lineColor: '#666666',
                                                                lineWidth: 1,
                                                                cursor: 'pointer',
                                                                marker: {
                                                                    lineWidth: 1,
                                                                    lineColor: '#666666',
                                                                    enabled: false,
                                                                    symbol: 'circle',
                                                                    radius: 2,
                                                                    states: {
                                                                        hover: {
                                                                        enabled: true
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        series: [{
                                                            name: '<?php echo $lang['lang_info_espectadores_conectados_estatisticas_total_espectadores_ontem']; ?>',
                                                            data: [<?php
                                                            
                                                            $data_ontem = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-1, date("Y")));
                                                            
                                                            for($i=0;$i<=23;$i++){
                                                            
                                                            $hora = sprintf("%02s",$i);
                                                            
                                                            $total_espectadores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".$data_ontem."' AND HOUR(hora) = '".$hora."'"));
                                                            
                                                            $array_total_espectadores .= $total_espectadores.",";
                                                            
                                                            }
                                                            echo substr($array_total_espectadores, 0, -1);  
                                                            
                                                            unset($array_total_espectadores);
                                                            unset($total_espectadores);
                                                            ?>]
                                                            }, {
                                                            name: '<?php echo $lang['lang_info_espectadores_conectados_estatisticas_total_espectadores_hoje']; ?>',
                                                            data: [<?php
                                                            
                                                            for($i=0;$i<=23;$i++){
                                                            
                                                            $hora = sprintf("%02s",$i);
                                                            
                                                            $total_espectadores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND data = '".date("Y-m-d")."' AND HOUR(hora) = '".$hora."'"));
                                                            
                                                            $array_total_espectadores .= $total_espectadores.",";
                                                            
                                                            }
                                                            echo substr($array_total_espectadores, 0, -1);  
                                                            
                                                            unset($array_total_espectadores);
                                                            unset($total_espectadores);
                                                            ?>]
                                                        }]
                                                    });
                                                });
                                                
                                            });
                                            </script>
                                        <div id="grafico_horas" style="width:100%; height: 350px; margin: 0 auto"></div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>

                        <?php if(@count($estatisticas) <= 0) { ?>
                        <div class="alert alert-warning text-center" role="alert"><?php echo $lang['lang_info_espectadores_conectados_info_sem_espectadores']; ?></div>
                    <?php }?>

          </div>
        </div>
      </div>
      <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
        </div>
                
        <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
    </div>
  </div>
  <script>
  status_streaming('<?php echo $login_code; ?>');
  setInterval("status_streaming('<?php echo $login_code; ?>')",60000);
        setTimeout("window.location.reload();",120000);    
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
  </script>
</body>
</html>
<?php
// Apaga os espectadores antigos
mysqli_query($conexao,"Delete From espectadores_conectados where codigo_stm = '".$dados_stm["codigo"]."' AND atualizacao < (NOW() - INTERVAL 2 MINUTE)");
?>