<?php
use WHMCS\Database\Capsule;

function streamingvideo_configoptions(){
    
    $configarray = array(
        'Espectadores' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de Espectadores. Ex.: 100)'
        ),
        'Bitrate' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Verifique limite de seu plano)'
        ),
        'Espaco AutoDJ' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Espaco para FTP em megabytes)'
        ),
        'Idioma' => array(
            'Type' => 'dropdown',
            'Options' => 'pt-br,en-us,es',
            'Description' => '<br>(Idioma Painel - Portugues/English/Espanol)'
        ),
        'Aplicacao' => array(
            'Type' => 'dropdown',
            'Options' => 'live,tvstation,vod,ipcamera',
            'Description' => '<br>(Live - Somente ao vivo | TvStation - ao vivo e ondemand/playlist | VOD - ondemand | IP Camera)'
        ),
        'Lives' => array(
            'Type' => 'yesno',
            'Description' => '(Ativar/desativar Lives redes sociais)'
        ),
    );
    
    return $configarray;
    
}

function streamingvideo_adminlink($params){
    $code = '<input type="button" value="Acessar Painel" onclick="window.location = \'http://' . $params['serverhostname'] . '/admin\';">';
    return $code;
}

function streamingvideo_createaccount($params){
    
    global $debug;
      

  $login = str_replace(" ","",$params['clientsdetails']['firstname']);
  $login = $login.mt_rand(1000,9999);
  $login = strtolower($login);

  $streamingvideo_api['acao'] = 'cadastrar';
  $streamingvideo_api['login'] = $login;
  $streamingvideo_api['espectadores'] = $params['configoption1'];
  $streamingvideo_api['bitrate'] = $params['configoption2'];
  $streamingvideo_api['espaco'] = $params['configoption3'];
  $streamingvideo_api['senha'] = substr(md5("acegikmoqsuxywz".time()),0,12);
  $streamingvideo_api['aplicacao'] = $params['configoption5'];
  $streamingvideo_api['idioma'] = $params['configoption4'];
  $streamingvideo_api['identificacao'] = urlencode($params['clientsdetails']['firstname']." ".$params['clientsdetails']['lastname']);
  $streamingvideo_api['email'] = $params['clientsdetails']['email'];
  $streamingvideo_api['lives'] = $params['configoption6'];
  
    $response = streamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$streamingvideo_api);
  
    if ($response['command'] == 'success'){
    
    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => $login, "password" => encrypt ($streamingvideo_api['senha']), "domain" => $response['returned'])
    );
    streamingvideo_update($parametros);
    
    return 'success';

    }

    return $response['error'];
}

function streamingvideo_suspendaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblhosting',
    'value' => 'username',
    'condition' => array("id" => $params['accountid'])
  );
  
  $login = streamingvideo_select($parametros);
  
    if (empty($login)){
      $return = 'Erro ao obter login do streaming.';
      return $return;
    }

    $streamingvideo_api['acao'] = 'bloquear';
    $streamingvideo_api['login'] = $login;

    $response = streamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$streamingvideo_api);

    if ($response['command'] == 'success'){

      return 'success';

    }

    return $response['error'];

}

function streamingvideo_unsuspendaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblhosting',
    'value' => 'username',
    'condition' => array("id" => $params['accountid'])
  );
  
  $login = streamingvideo_select($parametros);
  
    if (empty($login)){
      $return = 'Erro ao obter login do streaming.';
      return $return;
    }

    $streamingvideo_api['acao'] = 'desbloquear';
    $streamingvideo_api['login'] = $login;

    $response = streamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$streamingvideo_api);

    if ($response['command'] == 'success'){
      return 'success';
    }
  
    return $response['error'];

  }

function streamingvideo_terminateaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblhosting',
    'value' => 'username',
    'condition' => array("id" => $params['accountid'])
  );
  
  $login = streamingvideo_select($parametros);
  
    if (empty($login)){
      $return = 'Erro ao obter login do streaming.';
      return $return;
    }

    $streamingvideo_api['acao'] = 'remover';
    $streamingvideo_api['login'] = $login;
  
    $response = streamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$streamingvideo_api);

    if ($response['command'] == 'success'){
    
    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => '', "password" => '', "domain" => '')
    );
    streamingvideo_update($parametros);
    
    return 'success';

    }
  
    return $response['error'];

}

function streamingvideo_api($serverhostname, $serveraccesshash, $streamingvideo_api){

    $requisicao = '';
    
    foreach ($streamingvideo_api as $option => $setting) {
        if (is_array($setting)) {
            $setting = serialize($setting);
        }
        $requisicao .= $setting . "/";
    }

    $url_requisicao = "https://" . $serverhostname . "/admin/api/" . $serveraccesshash . "/" . $requisicao . "";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_requisicao);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Modulo Streaming WHMCS 3.0 (' . $_SERVER['HTTP_HOST'] . ')');
    $resultado = curl_exec($ch);
    curl_close($ch);
    

    if ($resultado === false) {
        return array(
            'command' => 'failed',
            'error' => 'No foi possvel se conectar ao painel de controle. Debug: ' . $url_requisicao . ''
        );
    } else if (empty($resultado)) {
        return array(
            'command' => 'failed',
            'error' => 'No foi possvel se conectar ao painel de controle. Debug: ' . $url_requisicao . ''
        );
    } else {
        list($status, $porta, $msg) = explode('|', $resultado);
        if ($status == '0') {
            return array(
                'command' => 'failed',
                'error' => '' . $msg . ''
            );
        }

        return array(
            'command' => 'success',
            'returned' => '' . $porta . ''
        );
    }
}

//Funes de conexo com o banco
function streamingvideo_select($parametros){
  
  $table = $parametros['table'];
  $value = $parametros['value'];
  $condition = $parametros['condition'];
  
  try {
    if(!empty($condition) && !empty($value)){
      $data = Capsule::table($table)
            ->where($condition)
            ->value($value);
            return $data;
    }else if(!empty($condition)){
      $data = Capsule::table($table)
            ->where($condition)
            ->get();
            return $data;
    }else if(!empty($value)){
      $data = Capsule::table($table)
            ->value($value);
            return $data;
    }else if(empty($condition) && empty($value)){
      $data = Capsule::table($table)
            ->get();
          return $data;
    }else{
      return "Erro na sintaxe da consulta";
    } 
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function streamingvideo_insert($parametros){
  
  $table = $parametros['table'];
  $insert_array = $parametros['insert_array'];
  
  try {
    Capsule::table($table)
      ->insert($insert_array);
    return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function streamingvideo_update($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  $update_data = $parametros['update_data'];
  
  try {
    Capsule::table($table)
       ->where($condition)
       ->update($update_data);
    return true;   
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function streamingvideo_delete($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  
  try {
    Capsule::table($table)
      ->where($condition)
      ->delete();
      return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
?>