<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND login = '".$dados_stm["login"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

$estatistica = query_string('1');
$mes = query_string('2');
$ano = query_string('3');

$total_espectadores_db = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$total_espectadores_unicos_db = mysqli_num_rows(mysqli_query($conexao,"SELECT DISTINCT ip FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$tempo_conectado = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));

$average_espectadores = $tempo_conectado["total_tempo"]/$tempo_conectado["total_registros"];

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["login"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">  
  <?php if($dados_stm["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico" />
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="https://code.highcharts.com/highcharts.js"></script>
  <script src="https://code.highcharts.com/highcharts-3d.js"></script>
  <script src="https://code.highcharts.com/modules/exporting.js"></script>
  <script src="/inc/theme.js"></script>
</head>
<body>
  <div class="container-scroller">
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><i class="fa fa-video-camera text-muted"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $login_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-warning" href="javascript:reiniciar_streaming('<?php echo $login_code; ?>');"> <?php echo $lang['lang_botao_titulo_reiniciar']; ?> Streaming</a>
              <?php if($dados_stm["srt_status"] == 'sim') { ?>
              <a class="dropdown-item text-primary" href="javascript:reiniciar_srt('<?php echo $login_code; ?>');"> <?php echo $lang['lang_botao_titulo_reiniciar']; ?> SRT</a>
              <?php } ?>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $login_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>
    <div class="container-fluid page-body-wrapper">
      <?php require_once("menu.php"); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_info_estatisticas_registros_tab_titulo']; ?></header>
                  </div>
                <div class="card-body">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                              <td width="25%" height="70" align="center"><i class='fa fa-users f-48 text-blue'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-user f-48 text-blue'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-bar-chart-o f-48 text-blue'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-clock-o f-48 text-blue'></i></td>
                                            </tr>
                                            <tr>
                                              <td height="30" align="center"><?php echo $total_espectadores_db; ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores']; ?></td>
                                              <td align="center"><?php echo $total_espectadores_unicos_db; ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores_unicos']; ?></td>
                                              <td align="center"><?php echo $total_espectadores_db; ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores_pico']; ?></td>
                                              <td align="center"><?php echo seconds2time($average_espectadores); ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores_tempo_conectados']; ?></td>
                                            </tr>
                                          </table>
                </div>
              </div>
            </div>        

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_info_estatisticas_estatistica']; ?></header>
                  </div>
                <div class="card-body">
                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="120" height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_estatisticas_estatistica']; ?></td>
                                            <td align="left">
                                            <select name="estatistica" class="form-control" id="estatistica" style="width:100%;" onchange="tipo_estatistica(this.value);">
                                              <option value="1"><?php echo $lang['lang_info_estatisticas_estatistica_espectadores']; ?></option>
                                              <option value="2"><?php echo $lang['lang_info_estatisticas_estatistica_tempo_conectado']; ?></option>
                                              <option value="3"><?php echo $lang['lang_info_estatisticas_estatistica_paises']; ?></option>
                                              <option value="4"><?php echo $lang['lang_info_estatisticas_estatistica_players']; ?></option>
                                              <option value="5"><?php echo $lang['lang_info_estatisticas_estatistica_espectadores_hora']; ?></option>
                                            </select>
                                            </td>
                                          </tr>
                                          <tr>
                                            <td colspan="2" align="left">
                                            <table width="100%" border="0" cellspacing="0" cellpadding="0" id="tabela_data">
                                              <tr>
                                                <td width="120" height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_estatisticas_periodo']; ?></td>
                                            <td align="left"><div class="input-group">
                                            <select name="mes" class="form-control" id="mes" style="width:162px;">
                                              <option value="01" <?php if(date("m") == '01') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_01']; ?></option>
                                              <option value="02" <?php if(date("m") == '02') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_02']; ?></option>
                                              <option value="03" <?php if(date("m") == '03') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_03']; ?></option>
                                              <option value="04" <?php if(date("m") == '04') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_04']; ?></option>
                                              <option value="05" <?php if(date("m") == '05') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_05']; ?></option>
                                              <option value="06" <?php if(date("m") == '06') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_06']; ?></option>
                                              <option value="07" <?php if(date("m") == '07') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_07']; ?></option>
                                              <option value="08" <?php if(date("m") == '08') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_08']; ?></option>
                                              <option value="09" <?php if(date("m") == '09') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_09']; ?></option>
                                              <option value="10" <?php if(date("m") == '10') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_10']; ?></option>
                                              <option value="11" <?php if(date("m") == '11') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_11']; ?></option>
                                              <option value="12" <?php if(date("m") == '12') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_12']; ?></option>
                                            </select>&nbsp;
                                            <select name="ano" class="form-control" id="ano" style="width:90px;">
                                                <?php
                                                    $ano_inicial = date("Y")-1;
                                                    $ano_final = date("Y")+1;
                                                    $qtd = $ano_final-$ano_inicial;
                                                        for($i=0; $i <= $qtd; $i++) {
                                                                if(sprintf("%02s",$ano_inicial+$i) == date("Y")) {
                                                                    echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\" selected=\"selected\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                                } else {
                                                                    echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                                }
                                                        }
                                                ?>
                                            </select></div>
                                            </td>
                                              </tr>
                                            </table>
                                            </td>
                                          </tr>
                                          <tr>
                                            <td height="50" colspan="2" align="right"><button type="button" class="btn btn-info" onclick="window.location = '/estatisticas/'+document.getElementById('estatistica').value+'/'+document.getElementById('mes').value+'/'+document.getElementById('ano').value+'';"><?php echo $lang['lang_botao_titulo_visualizar']; ?></button></td>
                                          </tr>
                                        </table>
                </div>
              </div>
            </div>        
            <?php if(!empty($estatistica)) { ?>
            <div class="col-lg-12">
              <div class="card">
                <div class="card-body text-center">
                    <?php if($estatistica == "1") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'area'
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_espectadores']; ?>'
            },
            subtitle: {
                text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano; ?>'
            },
            xAxis: {
                categories: [
                <?php
                $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                
                for($i=1;$i<=$array_dias_meses[$mes];$i++){
                
                $dias .= sprintf("%02s",$i).",";

                }
                
                echo substr($dias, 0, -1);          
                ?>              
                ],
                tickmarkPlacement: 'on',
                title: {
                    enabled: false
                }
            },
            yAxis: {
                title: {
                    text: '<?php echo $lang['lang_info_estatisticas_info_stats_espectadores_total']; ?>'
                },
                labels: {
                    formatter: function() {
                        return this.value;
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    return ''+
                        this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_espectadores']; ?>';
                }
            },
            plotOptions: {
                area: {
                    stacking: 'normal',
                    lineColor: '#666666',
                    lineWidth: 1,
                    cursor: 'pointer',
                    marker: {
                        lineWidth: 1,
                        lineColor: '#666666',
                        enabled: false,
                        symbol: 'circle',
                        radius: 2,
                        states: {
                            hover: {
                            enabled: true
                            }
                        }
                    }
                }
            },
            series: [{
                name: '<?php echo $lang['lang_info_estatisticas_estatistica_espectadores']; ?>',
                data: [
                <?php
                
                for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                
                $dia = sprintf("%02s",$i);
                
                $total_espectadores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND DAY(data) = '".$dia."'"));
                
                echo $total_espectadores.",";
                echo "\n";
                
                }
                ?>
                ]
            }]
        });
    });
    
});
</script>

<?php } else if($estatistica == "2") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'area'
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_tempo_conectado']; ?>'
            },
            subtitle: {
                text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
            },
            xAxis: {
                categories: [
                <?php
                $array_dias_meses = array("01" => "31", "02" => "28", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                
                for($i=1;$i<=$array_dias_meses[$mes];$i++){
                
                $dias .= sprintf("%02s",$i).",";

                }
                
                echo substr($dias, 0, -1);          
                ?>              
                ],
                tickmarkPlacement: 'on',
                title: {
                    enabled: false
                }
            },
            yAxis: {
                title: {
                    text: '<?php echo $lang['lang_info_estatisticas_info_stats_tempo_conectado_tempo_minutos']; ?>'
                },
                labels: {
                    formatter: function() {
                        return this.value;
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    return ''+
                        this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_minutos']; ?>';
                }
            },
            plotOptions: {
                area: {
                    stacking: 'normal',
                    lineColor: '#666666',
                    lineWidth: 1,
                    cursor: 'pointer',
                    marker: {
                        lineWidth: 1,
                        lineColor: '#666666',
                        enabled: false,
                        symbol: 'circle',
                        radius: 2,
                        states: {
                            hover: {
                            enabled: true
                            }
                        }
                    }
                }
            },
            series: [{
                name: '<?php echo $lang['lang_info_estatisticas_info_stats_tempo_conectado_tempo_minutos']; ?>',
                data: [
                <?php
                for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                
                $dia = sprintf("%02s",$i);
                
                $soma = 0;
                $contador = 0;
                
                $query = mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND DAY(data) = '".$dia."'");
                
                while ($dados_estatistica = mysqli_fetch_array($query)) {

                $soma += $dados_estatistica["tempo_conectado"];
                $contador++;

                }
                
                $media = ($contador > 0) ? $soma / $contador : '0';
                
                echo date('i',mktime(0,0,$media,15,03,2013)).",";
                echo "\n";
                
                }
                ?>
                ]
            }]
        });
    });
    
});

</script>

<?php } else if($estatistica == "3") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'pie',
                    options3d: {
                        enabled: true,
                        alpha: 45,
                        beta: 0
                    }
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_pais']; ?>'
            },
            tooltip: {
                formatter: function() {
                    return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    depth: 35,
                    dataLabels: {
                        enabled: true
                    },
                    showInLegend: true
                }
            },
            series: [{
                type: 'pie',
                name: '<?php echo $lang['lang_info_estatisticas_info_stats_pais_espectadores']; ?>',
                data: [
                
                <?php
                
                $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by pais ORDER by total DESC LIMIT 5");
                while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                if($dados_pais_ip["total"] > 1) {
                
                echo "['".$dados_pais_ip["pais"]."', ".$dados_pais_ip["total"]."],";
                echo "\n";

                }

                }
                
                ?>

                ]
            }]
        });
    });
    
});
</script>

<?php } else if($estatistica == "4") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'pie',
                    options3d: {
                        enabled: true,
                        alpha: 45,
                        beta: 0
                    }
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_players']; ?>'
            },
            tooltip: {
                formatter: function() {
                    return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    depth: 35,
                    dataLabels: {
                        enabled: true
                    },
                    showInLegend: true
                }
            },
            series: [{
                type: 'pie',
                data: [
                
                <?php
                
                $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND player != '' GROUP by player ORDER by total DESC");
                while ($dados_player = mysqli_fetch_array($sql_players)) {

                if($dados_player["total"] > 0) {
                
                echo "['".$dados_player["player"]."', ".$dados_player["total"]."],";
                echo "\n";

                }

                }
                
                ?>

                ]
            }]
        });
    });
    
});
</script>

<?php } else if($estatistica == "5") { ?>
<script type="text/javascript">

$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'area'
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_estatistica_espectadores_hora']; // espectadores Conectados por Hora ?>'
            },
            subtitle: {
                text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
            },
            xAxis: {
                categories: ['00:00-00:59','01:00-01:59','02:00-02:59','03:00-03:59','04:00-04:59','05:00-05:59','06:00-06:59','07:00-07:59','08:00-08:59','09:00-09:59','10:00-10:59','11:00-11:59','12:00-12:59','13:00-13:59','14:00-14:59','15:00-15:59','16:00-16:59','17:00-17:59','18:00-18:59','19:00-19:59','20:00-20:59','21:00-21:59','22:00-22:59','23:00-23:59'],
                tickmarkPlacement: 'on',
            },
            yAxis: {
                title: {
                    text: '<?php echo $lang['lang_info_estatisticas_info_stats_espectadores_total']; // Total de espectadores ?>'
                },
                labels: {
                    formatter: function() {
                        return this.value;
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    return ''+this.x+': '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_espectadores']; // ouvinte(s) ?>';
                }
            },
            plotOptions: {
                area: {
                    stacking: 'normal',
                    lineColor: '#666666',
                    lineWidth: 1,
                    cursor: 'pointer',
                    marker: {
                        lineWidth: 1,
                        lineColor: '#666666',
                        enabled: false,
                        symbol: 'circle',
                        radius: 2,
                        states: {
                            hover: {
                            enabled: true
                            }
                        }
                    }
                }
            },
            series: [{
                name: '<?php echo $lang['lang_info_estatisticas_estatistica_espectadores']; ?>',
                data: [<?php
                
                for($i=0;$i<=23;$i++){
                
                $hora = sprintf("%02s",$i);
                
                $total_espectadores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'"));
                
                $array_total_espectadores .= $total_espectadores.",";
                
                }
                echo substr($array_total_espectadores, 0, -1);  
                
                unset($array_total_espectadores);
                unset($total_espectadores);
                ?>]
            }]
        });
    });
    
});

</script>
<?php } ?>
<div id="container" style="min-width: 100%; height: auto; margin: 0 auto"></div>
                </div>
              </div>
            </div>
<?php } ?>
          </div>
        </div>
      </div>
      <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
        </div>
                
        <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
    </div>
  </div>
  
  <script>
  status_streaming('<?php echo $login_code; ?>');
  setInterval("status_streaming('<?php echo $login_code; ?>')",60000);
  </script>
</body>
</html>