<?php
use WHMCS\Database\Capsule;

function subrevendastreamingvideo_configoptions(){
    
    $configarray = array(
        'Streamings' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de contas. Ex.: 100)'
        ),
        'Espectadores' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de Espectadores. Ex.: 100)'
        ),
        'Bitrate' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Verifique limite de seu plano)'
        ),
        'Espaco AutoDJ' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Espaco para FTP em megabytes)'
        ),
        'Idioma' => array(
            'Type' => 'dropdown',
            'Options' => 'pt-br,en-us,es',
            'Description' => '<br>(Idioma Painel - Portugues/English/Espanol)'
        ),
        'Subrevendas' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de subrevendas. Ex.: 10)'
        )
    );
    
    return $configarray;
    
}

function subrevendastreamingvideo_adminlink($params){
    $code = '<input type="button" value="Acessar Painel" onclick="window.location = \'http://' . $params['serverhostname'] . '/admin\';">';
    return $code;
}

function subrevendastreamingvideo_createaccount($params){
    
    global $debug;
      
  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);

  if(empty($data)){
    $return = 'O campo adicional "ID" no existe.<br>Crie um campo adicional com o nome "Porta" em Products/Services';
    return $return;
  }
  
    $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);

    if(empty($data)){
    $parametros = array(
      'table' => 'tblcustomfieldsvalues',
      'insert_array' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'], "value" => '')
    );
    subrevendastreamingvideo_insert($parametros);
    }
  
    $ID = $data;

    if (!empty($ID)){
    $return = 'Esta revenda j esta criada.';
    return $return;
    }


  $subrevendastreamingvideo_api['acao'] = 'cadastrar_subrevenda';
  $subrevendastreamingvideo_api['streamings'] = $params['configoption1'];
  $subrevendastreamingvideo_api['espectadores'] = $params['configoption2'];
  $subrevendastreamingvideo_api['bitrate'] = $params['configoption3'];
  $subrevendastreamingvideo_api['espaco'] = $params['configoption4'];
  $subrevendastreamingvideo_api['idioma'] = $params['configoption5'];
  $subrevendastreamingvideo_api['email'] = $params['clientsdetails']['email'];
  $subrevendastreamingvideo_api['senha'] = substr(md5("acegikmoqsuxywz".time()),0,12);
  $subrevendastreamingvideo_api['subrevendas'] = $params['configoption6'];
  
    $response = subrevendastreamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastreamingvideo_api);
  
    if ($response['command'] == 'success'){
    
    $ID = $response['returned'];

    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => $ID, "password" => encrypt ($subrevendastreamingvideo_api['senha']))
    );
    subrevendastreamingvideo_update($parametros);
      
    $parametros = array(
      'table' => 'tblcustomfields',
      'value' => 'id',
      'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
    );
    $data = subrevendastreamingvideo_select($parametros);
    
    $dados_customfield = $data;

    
    $parametros = array(
      'table' => 'tblcustomfieldsvalues',
      'condition' => array("fieldid" => $dados_customfield, "relid" => $params['accountid']),
      'update_data' => array("value" => $ID)
    );
    subrevendastreamingvideo_update($parametros);
    
    return 'success';

    }

    return $response['error'];
}

function subrevendastreamingvideo_suspendaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);
  
  $ID = $data;

  if (empty($ID)){
    $return = 'A revenda no esta cadastrado.';
    return $return;
    }

    $subrevendastreamingvideo_api['acao'] = 'bloquear_subrevenda';
    $subrevendastreamingvideo_api['id'] = $ID;

    $response = subrevendastreamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastreamingvideo_api);

    if ($response['command'] == 'success'){

      return 'success';

    }

    return $response['error'];

}

function subrevendastreamingvideo_unsuspendaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);
  
  $ID = $data;

  if (empty($ID)){
    $return = 'A revenda no esta cadastrado.';
    return $return;
    }

    $subrevendastreamingvideo_api['acao'] = 'desbloquear_subrevenda';
    $subrevendastreamingvideo_api['id'] = $ID;

    $response = subrevendastreamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastreamingvideo_api);

    if ($response['command'] == 'success'){
      return 'success';
    }
  
    return $response['error'];

  }

function subrevendastreamingvideo_terminateaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastreamingvideo_select($parametros);
  
  $ID = $data;

  if (empty($ID)){
    $return = 'A revenda no esta cadastrado.';
    return $return;
    }

    $subrevendastreamingvideo_api['acao'] = 'remover_subrevenda';
    $subrevendastreamingvideo_api['id'] = $ID;
  
    $response = subrevendastreamingvideo_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastreamingvideo_api);

    if ($response['command'] == 'success'){
    
    $parametros = array(
      'table'=>'tblcustomfieldsvalues',
      'condition'=>array('fieldid'=>$CustomFieldID, 'relid'=>$params['accountid'])
    );
    subrevendastreamingvideo_delete($parametros);
    
    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => '', "password" => '')
    );
    subrevendastreamingvideo_update($parametros);
    
    return 'success';

    }
  
    return $response['error'];

}

function subrevendastreamingvideo_api($serverhostname, $serveraccesshash, $subrevendastreamingvideo_api){

    $requisicao = '';
    
    foreach ($subrevendastreamingvideo_api as $option => $setting) {
        if (is_array($setting)) {
            $setting = serialize($setting);
        }
        $requisicao .= $setting . "/";
    }

    $url_requisicao = "https://" . $serverhostname . "/admin/api/" . $serveraccesshash . "/" . $requisicao . "";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_requisicao);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Modulo Streaming WHMCS 3.0 (' . $_SERVER['HTTP_HOST'] . ')');
    $resultado = curl_exec($ch);
    curl_close($ch);
    

    if ($resultado === false) {
        return array(
            'command' => 'failed',
            'error' => 'No foi possvel se conectar ao painel de controle. Debug: ' . $url_requisicao . ''
        );
    } else if (empty($resultado)) {
        return array(
            'command' => 'failed',
            'error' => 'No foi possvel se conectar ao painel de controle. Debug: ' . $url_requisicao . ''
        );
    } else {
        list($status, $porta, $msg) = explode('|', $resultado);
        if ($status == '0') {
            return array(
                'command' => 'failed',
                'error' => '' . $msg . ''
            );
        }

        return array(
            'command' => 'success',
            'returned' => '' . $porta . ''
        );
    }
}

//Funes de conexo com o banco
function subrevendastreamingvideo_select($parametros){
  
  $table = $parametros['table'];
  $value = $parametros['value'];
  $condition = $parametros['condition'];
  
  try {
    if(!empty($condition) && !empty($value)){
      $data = Capsule::table($table)
            ->where($condition)
            ->value($value);
            return $data;
    }else if(!empty($condition)){
      $data = Capsule::table($table)
            ->where($condition)
            ->get();
            return $data;
    }else if(!empty($value)){
      $data = Capsule::table($table)
            ->value($value);
            return $data;
    }else if(empty($condition) && empty($value)){
      $data = Capsule::table($table)
            ->get();
          return $data;
    }else{
      return "Erro na sintaxe da consulta";
    } 
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function subrevendastreamingvideo_insert($parametros){
  
  $table = $parametros['table'];
  $insert_array = $parametros['insert_array'];
  
  try {
    Capsule::table($table)
      ->insert($insert_array);
    return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function subrevendastreamingvideo_update($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  $update_data = $parametros['update_data'];
  
  try {
    Capsule::table($table)
       ->where($condition)
       ->update($update_data);
    return true;   
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function subrevendastreamingvideo_delete($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  
  try {
    Capsule::table($table)
      ->where($condition)
      ->delete();
      return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
?>